

var preleaseBlock = true;

function LibraryBlock(blockName, isPrelease)
{
	isPrelease = isPrelease || false;
	
	return {
		"+":  blockName,
		nsClass: "GELibraryBlockView",
		gxFaceModel: null,  	// clear so library block doesn't create anything
		h4PreReleaseBlock: isPrelease,
	};
}

markup.push({

	
	// --------------------------------------------------------
	// MARK: library bits

	LibraryChildList:
	{
		nsClass: "GXStackView",
        gxDefaultValue: true, // expanded!
		gxLateLayout: "V:|-(-999)-[self]",	// vertical position set by parent
        axIsIgnored: true,
		gxBackPainter: fillPainter("SidebarBackColor2"),
		gxIntrinsicWidth: 276,
	},

	
	LibraryDisclosureButton:
	{
		"+": "ButtonView",
		gxDisableOnNil: false,
        axHelp: "Expand or collapse a section of library blocks",
		axRoleDescription: "Disclosure Button",	
		gxLayout:
		[
			"H:|-0-[self]-0-|",
			"V:|-(-999)-[self(33)]",	// vertical position set by parent
		],
		gxBackPainter:
		{
			nsClass: "GXPainter",
			gxEdgeInsets: "0, 1, 0, 1",
			gxFillColor: "SidebarBackColor2",
		},
		gxForePainter:
		{
			"+": "LabelFore.useMarkup.mediumWeight.foreColor1.size135.left",
			gxEdgeInsets: "11, 6, 0, 4",
		},
		gxFocusRingPainter:
		{
			nsClass: "GXPainter",
			gxFillColor: "BlackColor",
			gxEdgeInsets: "3, 3, 3, 3",  // adjust to center better with checkbox
		},
		gxIntrinsicHeight: 33,
	},


	// --------------------------------------------------------
	// MARK: library list view

	LibraryRootList:
	{
		nsClass: "GXStackView",
		gxViewName: "libraryView",
        gxDefaultValue: true, // expanded!
		gxIntrinsicWidth: 276,
		gxExtraSize: 18,
		axIsIgnored: true,
		gxChildViews :
		[
            {
                "+": "LibraryDisclosureButton",
                gxTitle: "<disclosure/> Sources",
				axFormatter: disclosureAxFormatter("Sources"),
                gxValueKey: "uiState.librarySourcesExpanded",
            },
			{
				"+": "LibraryChildList",
				gxValueKey: "uiState.librarySourcesExpanded",
				gxChildViews:
				[
					LibraryBlock("ApplicationSourceBlock" ),
					LibraryBlock("AudioDeviceInputBlock" ),
					LibraryBlock("SystemAudioBlock" ),
				]
			},
            {
                "+": "LibraryDisclosureButton",
                gxTitle: "<disclosure/> Outputs",
				axFormatter: disclosureAxFormatter("Outputs"),
                gxValueKey: "uiState.libraryOutputsExpanded",
            },
			{
				"+": "LibraryChildList",
				gxValueKey: "uiState.libraryOutputsExpanded",
				gxChildViews:
				[
					LibraryBlock("AudioDeviceOutputBlock" ),
					LibraryBlock("AudioRecorderBlock"),
					LibraryBlock("RTMPBlock" ),
					LibraryBlock("BroadcastBlock" ),
				]
			},
            {
                "+": "LibraryDisclosureButton",
                gxTitle: "<disclosure/> Built-In Effects",
				axFormatter: disclosureAxFormatter("Built-In Effects"),
                gxValueKey: "uiState.libraryEffectsExpanded",
            },
			{
				"+": "LibraryChildList",
				gxValueKey: "uiState.libraryEffectsExpanded",
				gxChildViews:
				[
					LibraryBlock("Equalizer10Block" ),
					LibraryBlock("BalanceBlock" ),
					LibraryBlock("BassTrebleBlock" ),
					LibraryBlock("ChannelTweakerBlock" ),
					LibraryBlock("LowPassFilterBlock" ),
					LibraryBlock("MagicBoostBlock" ),
					LibraryBlock("MonoEnhancerBlock" ),
					LibraryBlock("PanBlock" ),
					LibraryBlock("SimpleCompressorBlock" ),
					LibraryBlock("GainEffectsBlock" ),
				]
			},
            {
                "+": "LibraryDisclosureButton",
                gxTitle: "<disclosure/> Meters",
				axFormatter: disclosureAxFormatter("Meters"),
                gxValueKey: "uiState.libraryMetersExpanded",
            },
			{
				"+": "LibraryChildList",
				gxValueKey: "uiState.libraryMetersExpanded",
				gxChildViews :
				[
					LibraryBlock("LevelMeterBlock" ),
					LibraryBlock("VUMeterBlock" ),
				]
			},
            {
                "+": "LibraryDisclosureButton",
                gxTitle: "<disclosure/> Advanced",
				axFormatter: disclosureAxFormatter("Advanced"),
                gxValueKey: "uiState.libraryAdvancedExpanded",
            },
			{
				"+": "LibraryChildList",
				gxValueKey: "uiState.libraryAdvancedExpanded",
				gxChildViews:
				[
					LibraryBlock("DeclickBlock" ),
					LibraryBlock("DehumBlock" ),
					LibraryBlock("DenoiseBlock" ),
					LibraryBlock("DuckingBlock" ),
					LibraryBlock("FIRFilterBlock" ),
					LibraryBlock("InputToggleBlock" ),
					LibraryBlock("MixerBlock" ),
					LibraryBlock("ParametricEQBlock" ),
					LibraryBlock("RNNoiseFilterBlock" ),
					LibraryBlock("SyncBlock" ),
					LibraryBlock("TimeShiftBlock" ),
					LibraryBlock("TranscribeBlock" ),
				]
			},
            {
                "+": "LibraryDisclosureButton",
                gxTitle: "<disclosure/> Audio Unit Effects",
				axFormatter: disclosureAxFormatter("Audio Unit Effects"),
                gxValueKey: "uiState.libraryAudioUnitsExpanded",
            },
			{
				"+": "LibraryChildList",
				gxValueKey: "uiState.libraryAudioUnitsExpanded",
				gxViewName: "audioUnitsListView",	// named so code can find it
				gxChildViews:
				[
                    // code adds AU library blocks
				]
			}
		]
	},

	// --------------------------------------------------------
	// MARK: library drag view

	LibraryDragView:
	{
		nsClass: "GXDrawView",
		gxViewShadow: "{0, 0, 0, 0.4}, {0, 1}, 2.5",
		gxLayout:
		[
		 	"H:[self(50)]",
		 	"V:[self(50)]",
		],
		gxBackPainter:
		{
			nsClass: "GXPainter",
			gxEdgeInsets: "4, 4, 4, 4",
			gxCornerRadius: 8.5,
			gxStrokeWidth: 3,
			gxFillColor: "ColorTheme1",
			gxFrameColor: "SelectionColor2",
		},
		gxForePainter:
		{
			nsClass: "GXImagePainter",
			gxAlignment: "0.5, 0.5",
		},
	},

})
